%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Simulation part of Exercise 7.7(b).
% File: exercise77_simul.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rng('default');
rng(1);

yy  = data;
nr  = length(yy);
ss1 = 0.0887;  % As given by fitted MAR model, 1st line
ss2 = 0.2020;

term1(1) = yy(1)-0.7107;
term2(1) = yy(2)-0.9784;
term1(2) = yy(2)-0.7107-1.1022*yy(1);
term2(2) = yy(2)-0.9784-1.5279*yy(1);

for i=3:nr
 term1(i) = yy(i)-0.7107-1.1022*yy(i-1)+0.2835*yy(i-2);
 term2(i) = yy(i)-0.9784-1.5279*yy(i-1)+0.8871*yy(i-2);
end

cdftermyy = 0.3163.*normcdf(term1,0,1)+0.6837.*normcdf(term2,0,1);

fterm1 = normpdf(term1./ss1,0,1);
fterm1 = fterm1.*0.3163;
fterm2 = normpdf(term2./ss2,0,1);
fterm2 = fterm2.*0.6837;
ftot   = fterm1 + fterm2;
f      = log(ftot); 

yyfr   = [f';cdftermyy'];
r      = yyfr;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Simulation part

T      = 20000+2;
Tboots = 20000;
sigma1 = 0.0887;  
sigma2 = 0.2020;

epsilon = normrnd(0,1,T,1);  
eta     = normrnd(0,1,T,1);  
yn      = zeros(Tboots,1);
ar1     = zeros(Tboots,1);
ar2     = zeros(Tboots,1);

y(1)  = 0.3163*0.7107+0.6837*0.9784;   % mean of MAR process
yn(1) = y(1);
xlim  = -norminv(0.3163,0,1);  

boolean(1) = xlim-eta(1);

if(boolean(1)<0);
  yn(2) = 0.7107+1.1022*yn(1)+sigma1*epsilon(2);
else
  yn(2) = 0.9784+1.5279*yn(1)+sigma2*epsilon(2);
end

boolean(2)=xlim-eta(2);
if(boolean(2)<0);
  yn(3) = 0.7107+1.1022*yn(2)-0.2835*yn(1)+sigma1*epsilon(3);
else
  yn(3) = 0.9784+1.5279*yn(2)-0.8871*yn(1)+sigma2*epsilon(3);
end

for i=4:T
  boolean(i) = xlim-eta(i);
  if (boolean(i-1)<0);
     yn(i) = 0.7107+1.1022*yn(i-1)-0.2835*yn(i-2)+sigma1*epsilon(i);        
  else  
     yn(i) = 0.9784+1.5279*yn(i-1)-0.8871*yn(i-2)+sigma2*epsilon(i);
  end
end

apu2     = yn;
ynn      = yn(3:20002,1);
z0boots1 = apu2(3:(Tboots+2));  % two lags
z0boots2 = apu2(2:(Tboots+1));  % one lag
z0boots3 = apu2(1:Tboots);      % original 

z0boots  = [z0boots1 z0boots2 z0boots3];
z0       = z0boots;

ar1 = 0.7107 + 1.1022*z0(:,1)-0.2835*z0(:,2); 
ar2 = 0.9784 + 0.9784*z0(:,1)-0.8871*z0(:,2);

cdfterms = 0.3163*normcdf((z0boots3-ar1)./sigma1,0,1)+...
           0.6837*normcdf((z0boots3-ar2)./sigma2,0,1);

fterm1s = normpdf((z0boots3-ar1)./ss1,0,1);
fterm1s = fterm1s.*0.3163;
fterm2s = normpdf((z0boots3-ar2)./ss2,0,1);
fterm2s = fterm2s.*0.6837;
ftots   = fterm1s + fterm2s;
fsim    = log(ftots); 

yysim  = [fsim;cdfterms];
apu3   = yysim;
nob    = 114;
rboots = apu3((nob+1):2*nob,:);

apu4   = gradient(z0boots);
gboots = apu4((nob+):2*nob,:);
sboots = apu4(1:nob,:);